using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<(int x, int y)> moves = new List<(int, int)>();
        for (int i = 0; i < n; i++)
        {
            var input = Console.ReadLine().Split();
            int x = int.Parse(input[0]);
            int y = int.Parse(input[1]);
            moves.Add((x, y));
        }

        long bestDist = 0;
        List<int> bestMoves = new List<int>();

        // Brute-force sve moguce kombinacije pokreta
        for (int mask = 1; mask < (1 << n); mask++) 
        {
            long x = 0, y = 0;
            List<int> selectedMoves = new List<int>();

            for (int i = 0; i < n; i++)
            {
                if ((mask & (1 << i)) != 0) 
                {
                    x += moves[i].x;
                    y += moves[i].y;
                    selectedMoves.Add(i + 1);
                }
            }

            long dist = x * x + y * y;
            if (dist > bestDist)
            {
                bestDist = dist;
                bestMoves = selectedMoves;
            }
        }

        Console.WriteLine(bestMoves.Count);
        Console.WriteLine(string.Join(" ", bestMoves));
    }
}